#if (defined __STDC__ && __STDC__) || defined __cplusplus
# include <stdlib.h>
#endif
#include <stdio.h>
#include <string.h>

void run_1() {
  char * str = malloc(7);

  memset(str, '\0', 8);

  free(str);
  exit(0);
}

void run_2() {
  char * str = malloc(128);

  free(str);
  free(str);
  exit(0);
}

extern int mallopt (int param, int value);
#define M_MXFAST          1

void run_3() {
  char * str = malloc(7);

  mallopt(1, 0);

  free(str);
  free(str);
  exit(0);
}

/* Typedef for assert handler. Must not call malloc, and should be thread-safe.
 * 'error' is the failed assertion, 'file' and 'line' the location.
 */ 
typedef void assert_handler_tp(const char *error, const char *file, int line);

/* Takes the new handler as argument, and returns the old handler 
 */
extern assert_handler_tp *dnmalloc_set_handler(assert_handler_tp *assert_handler);

void new_handler(const char *error, const char *file, int line)
{
  fputs("new handler, exit 3\n", stderr);
  exit (3);
}

void run_4() {
  char * str = malloc(7);

  /* example 
   */
  assert_handler_tp * old_handler;
  old_handler = dnmalloc_set_handler(new_handler);

  mallopt(1, 0);

  free(str);
  free(str);
  exit(0);
}

int main (int argc, char *argv[])
{
  if (argc > 1 && argv[1][0] == 'o')
    run_1();
  if (argc > 1 && argv[1][0] == 'd')
    run_2();
  if (argc > 1 && argv[1][0] == 'n')
    run_3();
  if (argc > 1 && argv[1][0] == 't')
    run_4();
  fprintf(stderr, "Usage: %s overflow_detect|double_free_detect|no_fastbin_double_free_detect|test_handler (%c)\n", 
	  argv[0], argv[1][0]);
  return 0;
}
